tell application "Xcode"
	if version = "3.2" or version = "3.2.1" then
		display alert "Xcode Incompatiblity" message "Xcode 3.2 and 3.2.1 broke the AppleScript interface for manipulating entities, breaking this script.

Dupe http://openradar.me/7289446 if you want it back." as warning
		return
	end if
	
	activate
	if not (exists active project document) then
		error "No active project. Please open an Xcode project and re-run the script."
	end if
	set mainWindowFilePath to associated file name of main window
	if mainWindowFilePath does not end with ".xcdatamodel" then
		error "Please open an .xcdatamodel file and re-run the script."
	end if
	tell item 1 of (every data model document whose path is mainWindowFilePath)
		using terms from application "Finder"
			display alert "Autocustomize Entity Classes" message "Automatically customize all generic entity classes based on their names? (This is undoable.)" buttons {"Cancel", "Auto-customize"} cancel button 1
		end using terms from
		if button returned of result is "Auto-customize" then
			repeat with entityIt in (every entity)
				set object class of entityIt to name of entityIt & "MO"
			end repeat
		end if
	end tell
end tell
activate